/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import no.statkart.launcher.client.Konfigurasjonsverdi;

class Konfigurasjon {
    private final Path rot;
    private final Properties properties;

    public Konfigurasjon(Path rot) {
        this.rot = rot;
        this.properties = this.getProperties();
    }

    synchronized String get(Konfigurasjonsverdi key) {
        return this.properties.getProperty(key.getKey());
    }

    synchronized boolean is(Konfigurasjonsverdi key) {
        return "true".equalsIgnoreCase(this.get(key));
    }

    private Properties getProperties() {
        Path propPath = this.rot.resolve("client.properties");
        if (!Files.exists(propPath, new LinkOption[0])) {
            throw new IllegalStateException("Finner ikke 'client.properties' i work-katalogen");
        }
        Properties p = new Properties();
        try {
            p.load(Files.newInputStream(propPath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Klarte ikke lese 'client.properties' i work-katalogen");
        }
        return p;
    }
}

