/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.KeyIterator;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.ValueIterator;
import java.util.Iterator;

public class RegistryKey {
    static boolean c_initSucceeded = false;
    RootKey m_root;
    String m_path;

    static native void testInitialized();

    public static void initialize() {
        RegistryKey.initialize("jRegistryKey");
    }

    public static synchronized void initialize(String string) {
        try {
            RegistryKey.testInitialized();
            c_initSucceeded = true;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary(string);
            RegistryKey.testInitialized();
            c_initSucceeded = true;
            return;
        }
    }

    public static boolean isInitialized() {
        return c_initSucceeded;
    }

    public static void checkInitialized() {
        if (!RegistryKey.isInitialized()) {
            throw new IllegalStateException("You must successfuly call method initialize before calling this method.");
        }
    }

    public RegistryKey() {
        RegistryKey.checkInitialized();
        this.m_root = RootKey.HKEY_CURRENT_USER;
        this.m_path = "";
    }

    public RegistryKey(RootKey rootKey) {
        this();
        this.m_root = rootKey;
    }

    public RegistryKey(String string) {
        this();
        this.m_path = string;
    }

    public RegistryKey(RootKey rootKey, String string) {
        RegistryKey.checkInitialized();
        this.m_root = rootKey;
        this.m_path = string;
    }

    public RootKey getRootKey() {
        return this.m_root;
    }

    public String getPath() {
        return this.m_path;
    }

    public String makePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (!"".equals(this.m_path)) {
            stringBuffer.append("\\");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getName() {
        return this.m_path.substring(1 + this.m_path.lastIndexOf("\\"));
    }

    public native boolean exists();

    public native void create();

    public RegistryKey createSubkey(String object) {
        object = new RegistryKey(this.m_root, this.makePath((String)object));
        ((RegistryKey)object).create();
        return object;
    }

    public native void delete();

    public native boolean hasSubkeys();

    public boolean hasSubkey(String object) {
        object = new RegistryKey(this.m_root, this.makePath((String)object));
        return ((RegistryKey)object).exists();
    }

    public Iterator subkeys() {
        return new KeyIterator(this);
    }

    public Iterator values() {
        return new ValueIterator(this);
    }

    public native boolean hasValue(String var1);

    public native boolean hasValues();

    public native RegistryValue getValue(String var1);

    public native void setValue(RegistryValue var1);

    public native void deleteValue(String var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_root.toString());
        if (!"".equals(this.m_path)) {
            stringBuffer.append("\\");
            stringBuffer.append(this.m_path);
        }
        return stringBuffer.toString();
    }
}

