/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.Connector;
import com.threerings.getdown.net.a;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Downloader {
    protected final Connector _conn;
    protected final Map<Resource, Long> _sizes = new HashMap<Resource, Long>();
    protected final Map<Resource, Long> _downloaded = new HashMap<Resource, Long>();
    protected long _start;
    protected long _bytesPerSecond;
    protected long _lastUpdate;
    protected volatile State _state = State.DOWNLOADING;
    protected static final long UPDATE_DELAY = 500L;

    public Downloader(Connector connector) {
        this._conn = connector;
    }

    public boolean download(Collection<Resource> object, int n2) {
        this.resolvingDownloads();
        Iterator<Resource> iterator = object.iterator();
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            try {
                this._sizes.put(resource, Math.max(this.checkSize(resource), 0L));
            }
            catch (IOException iOException) {
                this.downloadFailed(resource, iOException);
            }
        }
        long l2 = Downloader.sum(this._sizes.values());
        Log.log.info("Downloading " + object.size() + " resources", "totalBytes", l2, "maxConcurrent", n2);
        this._start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        object = object.iterator();
        while (object.hasNext()) {
            Resource resource = (Resource)object.next();
            File file = new File(resource.getLocal().getParent());
            if (!file.exists() && !file.mkdirs()) {
                Log.log.warning("Failed to create target directory for resource '" + resource + "'.", new Object[0]);
            }
            executorService.execute(new a(this, resource));
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(10L, TimeUnit.DAYS);
            if (this._state == State.DOWNLOADING) {
                this.downloadProgress(100, 0L);
            }
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            this.downloadFailed(null, interruptedException);
        }
        return this._state != State.ABORTED;
    }

    public void abort() {
        this._state = State.ABORTED;
    }

    protected void resolvingDownloads() {
    }

    protected void downloadProgress(int n2, long l2) {
    }

    protected void downloadFailed(Resource resource, Exception exception) {
    }

    protected long checkSize(Resource resource) throws IOException {
        URLConnection uRLConnection = this._conn.open(resource.getRemote(), 0, 0);
        try {
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
            }
            this._conn.checkConnectOK(uRLConnection, "Unable to check up-to-date for " + resource.getRemote());
            long l2 = uRLConnection.getContentLength();
            return l2;
        }
        finally {
            uRLConnection.getInputStream().close();
        }
    }

    protected synchronized void reportProgress(Resource resource, long l2, long l3) {
        l3 = Math.max(l3, this._sizes.get(resource));
        this._sizes.put(resource, l3);
        this._downloaded.put(resource, Math.min(l3, l2));
        long l4 = System.currentTimeMillis();
        if (l4 - this._lastUpdate >= 500L) {
            long l5;
            this._lastUpdate = l4;
            long l6 = Downloader.sum(this._downloaded.values());
            long l7 = Downloader.sum(this._sizes.values());
            long l8 = (l4 - this._start) / 1000L;
            long l9 = l8 == 0L ? 0L : l6 / l8;
            int n2 = l7 == 0L ? 0 : (int)((float)l6 * 100.0f / (float)l7);
            long l10 = l5 = l9 <= 0L || l7 == 0L ? -1L : (l7 - l6) / l9;
            if (this._state == State.DOWNLOADING) {
                if (n2 == 100) {
                    this._state = State.COMPLETE;
                }
                this.downloadProgress(n2, l5);
            }
        }
    }

    protected static long sum(Iterable<Long> object) {
        long l2 = 0L;
        object = object.iterator();
        while (object.hasNext()) {
            Long l3 = (Long)object.next();
            l2 += l3.longValue();
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void download(Resource resource) throws IOException {
        Object object = this._conn.open(resource.getRemote(), 0, 0);
        this._conn.checkConnectOK((URLConnection)object, "Unable to download resource " + resource.getRemote());
        long l2 = ((URLConnection)object).getContentLength();
        Log.log.info("Downloading resource", "url", resource.getRemote(), "size", l2);
        long l3 = 0L;
        byte[] byArray = new byte[16384];
        object = ((URLConnection)object).getInputStream();
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(resource.getLocalNew());
            Throwable throwable2 = null;
            try {
                int n2;
                while ((n2 = ((InputStream)object).read(byArray)) != -1 && this._state != State.ABORTED) {
                    fileOutputStream.write(byArray, 0, n2);
                    this.reportProgress(resource, l3 += (long)n2, l2);
                }
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable2 != null) {
                        try {
                            fileOutputStream.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable5;
                    } else {
                        fileOutputStream.close();
                    }
                    throw throwable5;
                }
            }
            fileOutputStream.close();
            if (object == null) return;
        }
        catch (Throwable throwable7) {
            try {
                Throwable throwable8 = throwable7;
                throwable = throwable7;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                if (object == null) throw throwable9;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable9;
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    throw throwable9;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable9;
            }
        }
        ((InputStream)object).close();
        return;
    }

    protected static enum State {
        DOWNLOADING,
        COMPLETE,
        FAILED,
        ABORTED;

    }
}

